/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;

namespace Borland.Eco.Persistence
{
	/// <summary>
	/// This class is used by KeyMappers that need to add structure to the database schema
	/// </summary>
	public class ColumnDescription
	{
		public ColumnDescription(string columnName, string columnType, bool allowNull, string defaultDbValue): base()
		{
			m_ColumnName = columnName;
			m_ColumnType = columnType;
			m_AllowNull = allowNull;
			m_DefaultDbValue = defaultDbValue;
		}
		private string m_DefaultDbValue;
		private string m_ColumnName;
		private string m_ColumnType;
		private bool m_AllowNull;
		public string ColumnName { get { return m_ColumnName; } }
		public string ColumnType { get { return m_ColumnType; } }
		public bool AllowNull { get { return m_AllowNull; } }
		public string DefaultDBValue { get { return m_DefaultDbValue; } }
	}
}
